//
//  FSFileOperation.h
//  Downloader
//
//  Created by LiDong on 13-3-18.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FSFileItem;

typedef void (^FSCompletionHandler)(BOOL completed);

typedef enum __OPERATION_TYPE : unsigned char {
    OPERATION_INVALID = 0,
    OPERATION_COPY,
    OPERATION_CUT,
    OPERATION_REMOVE,
    OPERATION_ZIP,
    OPERATION_UNZIP
} OPERATION_TYPE;

@class FSFileOperation;

@protocol FSFileOperationDelegate <NSObject>
@required
- (void)fileOperationDidBegin:(FSFileOperation *)operation;
- (void)fileOperationDidEnd:(FSFileOperation *)operation;
@end

@interface FSFileOperation : NSOperation {
    NSMutableArray *_srcPaths;
    NSString *_dstDirectory;
    NSCondition *_condition;
    char *_buffer;
    FSCompletionHandler _srcCompletionHandler;
    FSCompletionHandler _dstCompletionHandler;
    OPERATION_TYPE _operationType;
    BOOL _ignoreOnce;
    __weak id<FSFileOperationDelegate> _delegate;
}

@property (nonatomic, assign, readonly) OPERATION_TYPE operationType;
@property (assign) BOOL ignoreOnce;
@property (nonatomic, weak) id<FSFileOperationDelegate> delegate;

- (id)initWithOperationType:(OPERATION_TYPE)type;
- (void)setFileItems:(NSArray *)fileItems;
- (void)setDstPath:(NSString *)dstPath;
- (void)setSrcCompletionHandler:(FSCompletionHandler)handler;
- (void)setDstCompletionHandler:(FSCompletionHandler)handler;
- (BOOL)canPaste;

@end

